/*
 * Decompiled with CFR 0.152.
 */
package myau.property.properties;

import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import myau.property.Property;

public class FloatProperty
extends Property<Float> {
    private final Float minimum;
    private final Float maximum;

    public FloatProperty(String name, Float value, Float minimum, Float maximum) {
        this(name, value, minimum, maximum, null);
    }

    public FloatProperty(String string, Float value, Float minimum, Float maximum, BooleanSupplier check) {
        super(string, value, (T floatV) -> floatV.floatValue() >= 0.0f && floatV.floatValue() <= Float.MAX_VALUE, check);
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public String getValuePrompt() {
        return String.format("%s-%s", this.minimum, this.maximum);
    }

    @Override
    public String formatValue() {
        return String.format("&6%s", this.getValue());
    }

    @Override
    public boolean parseString(String string) {
        return this.setValue(Float.valueOf(Float.parseFloat(string)));
    }

    @Override
    public boolean read(JsonObject jsonObject) {
        return this.setValue(Float.valueOf(jsonObject.get(this.getName()).getAsNumber().floatValue()));
    }

    @Override
    public void write(JsonObject jsonObject) {
        jsonObject.addProperty(this.getName(), (Number)this.getValue());
    }

    public Float getMinimum() {
        return this.minimum;
    }

    public Float getMaximum() {
        return this.maximum;
    }
}

