/*
 * Decompiled with CFR 0.152.
 */
package myau.module;

import java.util.LinkedHashMap;
import myau.Myau;
import myau.event.EventTarget;
import myau.event.types.EventType;
import myau.events.KeyEvent;
import myau.events.TickEvent;
import myau.module.Module;
import myau.module.modules.GuiModule;
import myau.module.modules.HUD;
import myau.util.ChatUtil;
import myau.util.SoundUtil;

public class ModuleManager {
    private boolean sound = false;
    public final LinkedHashMap<Class<?>, Module> modules = new LinkedHashMap();

    public Module getModule(String string) {
        return this.modules.values().stream().filter(mD -> mD.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public Module getModule(Class<?> clazz) {
        return this.modules.get(clazz);
    }

    public void playSound() {
        this.sound = true;
    }

    @EventTarget
    public void onKey(KeyEvent event) {
        for (Module module : this.modules.values()) {
            if (module.getKey() != event.getKey()) continue;
            boolean shouldNotify = module.toggle();
            if (!shouldNotify) {
                HUD hud = (HUD)this.modules.get(HUD.class);
                if (hud != null) {
                    shouldNotify = (Boolean)hud.toggleAlerts.getValue();
                }
                if (module instanceof GuiModule) {
                    shouldNotify = false;
                }
            }
            if (!shouldNotify) continue;
            String status = module.isEnabled() ? "&a&lON" : "&c&lOFF";
            String message = String.format("%s%s: %s&r", Myau.clientName, module.getName(), status);
            ChatUtil.sendFormatted(message);
        }
    }

    @EventTarget
    public void onTick(TickEvent event) {
        if (event.getType() == EventType.PRE && this.sound) {
            this.sound = false;
            SoundUtil.playSound("random.click");
        }
    }
}

